/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AbstractAssessmentObservable;
import pse.assessment.AssessmentCompoundObservable;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherTask;
import pse.assessment.ProficiencyAssignment;
import pse.model.ModelConstants;
import pse.util.general.SimplePair;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssessmentSmv
extends AssessmentObject {
    protected List<SimplePair<String, String>> observableReferences = new ArrayList<SimplePair<String, String>>();
    protected List<AssessmentCompoundObservable> compoundObservables = new ArrayList<AssessmentCompoundObservable>();
    protected List<ProficiencyAssignment> proficiencyAssignments = new ArrayList<ProficiencyAssignment>();
    protected String smvType = ModelConstants.ASSESSMENT_SMV_OTHER_TYPE;
    protected String title;
    protected String vdsIdent;

    @Override
    public String getElementName() {
        return "smv";
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (SimplePair<String, String> simplePair : this.observableReferences) {
            AbstractAssessmentObservable abstractAssessmentObservable = consistencyChecker.getObservable(simplePair.getFirst(), simplePair.getSecond());
            if (abstractAssessmentObservable == null) {
                consistencyChecker.missingObservable(this, simplePair.getFirst(), simplePair.getSecond());
                continue;
            }
            if (abstractAssessmentObservable instanceof AssessmentCompoundObservable) continue;
            consistencyChecker.invalidObservableType(this, simplePair.getFirst(), simplePair.getSecond(), abstractAssessmentObservable);
        }
        for (ProficiencyAssignment proficiencyAssignment : this.proficiencyAssignments) {
            proficiencyAssignment.checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.nonEmptyString(this.title) || this.observableReferences.size() > 0 || this.proficiencyAssignments.size() > 0;
    }

    public int getMaximumPoints() {
        int n = 0;
        for (AssessmentCompoundObservable assessmentCompoundObservable : this.compoundObservables) {
            n += assessmentCompoundObservable.getMaximumPoints();
        }
        return n;
    }

    public List<AssessmentCompoundObservable> getCompoundObservables() {
        return this.compoundObservables;
    }

    public void addCompoundObservable(AssessmentCompoundObservable assessmentCompoundObservable) {
        this.compoundObservables.add(assessmentCompoundObservable);
    }

    public List<SimplePair<String, String>> getObservableReferences() {
        return this.observableReferences;
    }

    public void addObservableReference(SimplePair<String, String> simplePair) {
        this.observableReferences.add(simplePair);
    }

    public String getVdsProficiencyIdent(int n) {
        for (ProficiencyAssignment proficiencyAssignment : this.proficiencyAssignments) {
            if (!proficiencyAssignment.matches(n)) continue;
            return proficiencyAssignment.getVdsIdent();
        }
        return null;
    }

    public boolean hasProficiencyAssignments() {
        return !this.proficiencyAssignments.isEmpty();
    }

    public List<ProficiencyAssignment> getProficiencyAssignments() {
        return this.proficiencyAssignments;
    }

    public void addProficiencyAssignment(ProficiencyAssignment proficiencyAssignment) {
        this.proficiencyAssignments.add(proficiencyAssignment);
    }

    public boolean isDefault() {
        return this.smvType.equalsIgnoreCase(ModelConstants.ASSESSMENT_SMV_DEFAULT_TYPE);
    }

    public void setIsDefault(boolean bl) {
        this.smvType = bl ? ModelConstants.ASSESSMENT_SMV_DEFAULT_TYPE : ModelConstants.ASSESSMENT_SMV_OTHER_TYPE;
    }

    public String getSmvType() {
        return this.smvType;
    }

    public void setSmvType(String string) {
        this.smvType = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("type", this.smvType);
        xmlWriter.addAttribute("vds-ident", this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addOptionalTextElement("title", this.title);
        for (SimplePair<String, String> object : this.observableReferences) {
            xmlWriter.addElement("vds-observable-ref", "vds-task-ident", object.getFirst(), "vds-observable-ident", object.getSecond());
        }
        if (!this.proficiencyAssignments.isEmpty()) {
            xmlWriter.openElement("proficiencies");
            for (ProficiencyAssignment proficiencyAssignment : this.proficiencyAssignments) {
                this.addChild(xmlWriter, proficiencyAssignment);
            }
            xmlWriter.closeElement();
        }
    }

    protected void makeConnections(PantherTask pantherTask) {
        int n;
        if (this.compoundObservables.isEmpty()) {
            this.compoundObservables = new ArrayList<AssessmentCompoundObservable>(this.observableReferences.size());
            for (n = 0; n < this.observableReferences.size(); ++n) {
                this.compoundObservables.add(null);
            }
        }
        for (n = 0; n < this.observableReferences.size(); ++n) {
            SimplePair<String, String> simplePair = this.observableReferences.get(n);
            if (!simplePair.getFirst().equals(pantherTask.getVdsIdent())) continue;
            AssessmentCompoundObservable assessmentCompoundObservable = pantherTask.getCompoundObservableByVdsIdent(simplePair.getSecond());
            this.compoundObservables.set(n, assessmentCompoundObservable);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.smvType = XmlUtils.getOptionalAttribute(node, "type", this.smvType);
        this.vdsIdent = XmlUtils.getAttribute(node, "vds-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.title = XmlUtils.getChildText(node, "title");
        List<Node> list = XmlUtils.getNodeChildren(node, "vds-observable-ref");
        for (Node object : list) {
            String string = XmlUtils.getAttribute(object, "vds-task-ident");
            String string2 = XmlUtils.getAttribute(object, "vds-observable-ident");
            this.addObservableReference(new SimplePair<String, String>(string, string2));
        }
        Node node2 = XmlUtils.getChild(node, "proficiencies");
        if (node2 != null) {
            list = XmlUtils.getNodeChildren(node2, "proficiency-assignment");
            for (Node node3 : list) {
                this.addProficiencyAssignment((ProficiencyAssignment)this.readChildFromChildNode(node3, new ProficiencyAssignment()));
            }
        }
    }
}

